const VERSION = "v1";
const CACHE_NAME = `atelier-diabete-antille-${VERSION}`;

const tableau = [];
for (let i = 2; i <= 140; i++) {
  tableau.push(i);
}

const fontFiles = [
  "santor_1.002_2-webfont.woff",
  "santor_1.002_2-webfont.woff2",
  "SourceSansPro-Bold.woff",
  "SourceSansPro-Bold.woff2",
  "SourceSansPro-Light.woff",
  "SourceSansPro-Light.woff2",
  "sourcesanspro-regular-webfont.woff",
  "sourcesanspro-regular-webfont.woff2",
];
// Those are all the resources our app needs to work.
// We'll cache them on install.
const INITIAL_CACHED_RESOURCES = [
  "/css/index.css",
  "index.js",
  "/assets/audios/clic.mp3",
  "/assets/audios/gagne.mp3",
  "/assets/audios/perdu.mp3",
  "/assets/audios/priseObjet.mp3",
  "/assets/audios/bip_caisse.mp3",
  "/assets/audios/book_page_turn.mp3",
  "/assets/audios/caisse_enregistreuse.mp3",
  "/assets/audios/double_bip_caisse.mp3",
  "/assets/audios/magic_decouverte.mp3",
  "/assets/videos/bloc_autosurveillance.mp4",
  "/assets/videos/bloc_ig.mp4",
  "/assets/videos/bloc_le_chemin_du_sucre.mp4",
  "/assets/videos/bloc_les_acteurs_du_diabete.mp4",
  "/assets/videos/bloc_mes_traitements.mp4",
  "/assets/videos/bloc_mon_hygiene_de_vie.mp4",
  "/assets/videos/bloc_les_complications.mp4",
  "/assets/videos/diabete_type_I_desktop.mp4",
  "/assets/videos/diabete_type_II_desktop.mp4",
  "/assets/videos/normal_hyper_desktop.mp4",
  "/assets/videos/normal_hypo_desktop.mp4",
  "/assets/videos/normal_desktop.mp4",
  "/assets/images/desktop/fond.jpg",
  "/assets/images/fond.jpg",
  "/assets/images/logo.svg",
  "/assets/images/quitter.png",
  "/assets/images/arrow.png",
  "/assets/game_1/bananes.png",
  "/assets/game_1/biscote.png",
  "/assets/game_1/boeuf.png",
  "/assets/game_1/burger.png",
  "/assets/game_1/chocolat.png",
  "/assets/game_1/confiture.png",
  "/assets/game_1/fraises.png",
  "/assets/game_1/fruits.png",
  "/assets/game_1/jus.png",
  "/assets/game_1/legumes.png",
  "/assets/game_1/oignon.png",
  "/assets/game_1/pain.png",
  "/assets/game_1/pomme.png",
  "/assets/game_1/puree.png",
  "/assets/game_1/salade.png",
  "/assets/game_1/semoule.png",
  "/assets/game_1/soda.png",
  "/assets/game_1/tomate.png",
  "/assets/game_1/viande.png",
  "/assets/game_1/yaourts.png",
  "/assets/game_1/lait.png",
  "/assets/game_2/beurre.png",
  "/assets/game_2/biscotte.png",
  "/assets/game_2/bouteille_eau.png",
  "/assets/game_2/champignons.png",
  "/assets/game_2/chips.png",
  "/assets/game_2/chocolat.png",
  "/assets/game_2/cookies.png",
  "/assets/game_2/etagere.png",
  "/assets/game_2/etageres_top.png",
  "/assets/game_2/etageres.png",
  "/assets/game_2/mayonnaise.png",
  "/assets/game_2/huile.png",
  "/assets/game_2/legumes.png",
  "/assets/game_2/lumiere.png",
  "/assets/game_2/oignon.png",
  "/assets/game_2/pain.png",
  "/assets/game_2/panier_bleu.png",
  "/assets/game_2/panier_vert.png",
  "/assets/game_2/panier_rouge.png",
  "/assets/game_2/pates.png",
  "/assets/game_2/poisson.png",
  "/assets/game_2/saucisson.png",
  "/assets/game_2/pomme_de_terre.png",
  "/assets/game_2/soda.png",
  "/assets/game_2/tomates.png",
  "/assets/game_2/viande.png",
  "/assets/game_2/vin.png",
  "/assets/game_3/gros_plan_coeur.png",
  "/assets/game_3/gros_plan_sexe.png",
  "/assets/game_3/gros_plan_sang.png",
  "/assets/game_3/gros_plan_rein_malade.png",
  "/assets/game_3/gros_plan_poids.png",
  "/assets/game_3/gros_plan_pieds.png",
  "/assets/game_3/gros_plan_oeil.png",
  "/assets/game_3/gros_plan_nerf.png",
  "/assets/game_3/gros_plan_dents.png",
  "/assets/game_3/loupe.png",
  "/assets/game_3/perso_plein.png",
  "/assets/game_3/perso.png",
  "/assets/game_4/cerveau.png",
  "/assets/game_4/coeur.png",
  "/assets/game_4/estomac.png",
  "/assets/game_4/foie.png",
  "/assets/game_4/graisse.png",
  "/assets/game_4/illus_11.png",
  "/assets/game_4/illus_12.png",
  "/assets/game_4/intestins.png",
  "/assets/game_4/muscle.png",
  "/assets/game_4/pancreas.png",
  "/assets/game_4/reins.png",
  "/assets/game_4/illus_01.png",
  "/assets/game_4/illus_02.png",
  "/assets/game_4/illus_03.png",
  "/assets/game_4/illus_04.png",
  "/assets/game_4/illus_05.png",
  "/assets/game_4/illus_06.png",
  "/assets/game_4/illus_07.png",
  "/assets/game_4/illus_08.png",
  "/assets/game_4/illus_09.png",
  "/assets/game_4/illus_10.png",
  "/assets/game_4/illus_10_milieu.png",
  "/assets/game_4/lumiere.png",
  "/assets/game_5/1_etoile.jpg",
  "/assets/game_5/2_etoile.jpg",
  "/assets/game_5/3_etoile.jpg",
  "/assets/game_5/4_etoiles.jpg",
  "/assets/game_5/1x_bleu.jpg",
  "/assets/game_5/2x_bleu.jpg",
  "/assets/game_5/3x_bleu.jpg",
  "/assets/game_5/4x_bleu.jpg",
  "/assets/game_5/1x_violet.jpg",
  "/assets/game_5/2x_violet.jpg",
  "/assets/game_5/3x_violet.jpg",
  "/assets/game_5/4x_violet.jpg",
  "/assets/game_5/cours_a_pied.jpg",
  "/assets/game_5/tennis.jpg",
  "/assets/game_5/velo.jpg",
  "/assets/game_5/sports_collectifs.jpg",
  "/assets/game_5/salle_de_sport.jpg",
  "/assets/game_5/natation.jpg",
  "/assets/game_5/coche_violet.png",
  "/assets/game_6/close.png",
  "/assets/game_6/alpha.png",
  "/assets/game_6/biguanides.png",
  "/assets/game_6/glinides.png",
  "/assets/game_6/idpp.png",
  "/assets/game_6/glp.png",
  "/assets/game_6/insuline.png",
  "/assets/game_6/isglt.png",
  "/assets/game_6/sulfamides.png",
  "/assets/game_6/desktop/alpha.jpg",
  "/assets/game_6/desktop/biguanides.jpg",
  "/assets/game_6/desktop/glinides.jpg",
  "/assets/game_6/desktop/idpp.jpg",
  "/assets/game_6/desktop/glp.jpg",
  "/assets/game_6/desktop/insuline.jpg",
  "/assets/game_6/desktop/isglt.jpg",
  "/assets/game_6/desktop/sulfamides.jpg",
  "/assets/game_6/coche_bleu.png",
  "/assets/game_7/vignette_1.png",
  "/assets/game_7/vignette_2.png",
  "/assets/game_7/vignette_3.png",
  "/assets/game_7/vignette_4.png",
  "/assets/game_8/bouton_coche_bleu.png",
  "/assets/game_8/bouton_coche_int_bleu.png",
  "/assets/game_8/bouton_coche_int.png",
  "/assets/game_8/bouton_coche.png",
  "/assets/game_8/int_pompe.png",
  "/assets/game_8/item_glisser.png",
  "/assets/game_8/pompe_vide.png",
  "/assets/game_8/mesure.png",
  "/assets/game_8/lumiere_jaune.png",
  "/assets/images/logo_pop.png",
  "/assets/images/bt_legal.svg",
  "/assets/images/logo.svg",
  "/assets/images/bt_suivant.png",
  //GAME
  "/game/index.html",
  "/game/js/app.js",
  "/game/main.dd0113559b9e2dd3dce8.css",
  "/game/images/fond_plateau.jpg",
  "/game/images/2j.png",
  "/game/images/4j.png",
  "/game/images/bt_quitter_off.png",
  "/game/images/bt_quitter_on.png",
  "/game/images/case_off.png",
  "/game/images/case_on.png",
  "/game/images/defausse_deck_off.png",
  "/game/images/defausse_deck_on.png",
  "/game/images/depot_deck_off.png",
  "/game/images/depot_deck_on.png",
  "/game/images/icon_accompagnement_off.png",
  "/game/images/icon_accompagnement_on.png",
  "/game/images/icon_dessert_off.png",
  "/game/images/icon_dessert_on.png",
  "/game/images/icon_entree_off.png",
  "/game/images/icon_entree_on.png",
  "/game/images/icon_laitage_off.png",
  "/game/images/icon_laitage_on.png",
  "/game/images/icon_matiere-grasse_off.png",
  "/game/images/icon_matiere-grasse_on.png",
  "/game/images/icon_plat_off.png",
  "/game/images/icon_plat_on.png",
  "/game/images/jauge_coloree.png",
  "/game/images/jauge_pointeur.png",
  "/game/images/39767.svg",

  "/game/images/homes/croix.png",
  "/game/images/homes/ecran_01.png",
  "/game/images/homes/ecran_02.png",
  "/game/images/homes/ecran_03.png",
  "/game/images/homes/ecran_04.png",
  "/game/images/homes/ecran_05.png",
  "/game/images/homes/ecran_06.png",
  "/game/images/homes/logo.png",
  "/game/images/cards/NOVO.jpg",
  ...tableau.map((i) => "/game/images/cards/NOVO_" + i + "jpg"),
  ...fontFiles.map((i) => "/css/fonts/" + i),
];

// Add a cache-busting query string to the pre-cached resources.
// This is to avoid loading these resources from the disk cache.
const INITIAL_CACHED_RESOURCES_WITH_VERSIONS = INITIAL_CACHED_RESOURCES.map(
  (path) => {
    return `${path}?v=${VERSION}`;
  }
);

// On install, fill the cache with all the resources we know we need.
// Install happens when the app is used for the first time, or when a
// new version of the SW is detected by the browser.
// In the latter case, the old SW is kept around until the new one is
// activated by a new client.
self.addEventListener("install", (event) => {
  self.skipWaiting();

  event.waitUntil(
    (async () => {
      const cache = await caches.open(CACHE_NAME);
    
      cache.addAll(INITIAL_CACHED_RESOURCES_WITH_VERSIONS);
    })()
  );
});

// Activate happens after install, either when the app is used for the
// first time, or when a new version of the SW was installed.
// We use the activate event to delete old caches and avoid running out of space.
self.addEventListener("activate", (event) => {
  event.waitUntil(
    (async () => {
      const names = await caches.keys();
      await Promise.all(
        names.map((name) => {
          if (name !== CACHE_NAME) {
            return caches.delete(name);
          }
        })
      );
      await clients.claim();
    })()
  );
});

// Main fetch handler.
// A cache-first strategy is used, with a fallback to the network.
// The static resources fetched here will not have the cache-busting query
// string. So we need to add it to match the cache.
self.addEventListener("fetch", (event) => {
  const url = new URL(event.request.url);

  // Don't care about other-origin URLs.
  if (url.origin !== location.origin) {
    return;
  }

  // Don't care about anything else than GET.
  if (event.request.method !== "GET") {
    return;
  }

  // On fetch, go to the cache first, and then network.
  event.respondWith(
    (async () => {
      const cache = await caches.open(CACHE_NAME);
      const cachedResponse = await cache.match(
        `${event.request.url}?v=${VERSION}`
      );

      if (cachedResponse) {
        return cachedResponse;
      } else {
        const fetchResponse = await fetch(event.request, {cache: "no-store"});
        cache.put(event.request, fetchResponse.clone());
        return fetchResponse;
      }
    })()
  );
});
